#pragma execution_character_set("utf-8")
#include "script_functions.h"
#include "nba2kol2_keys.h"
#include <fstream>
#include <nlohmann/json.hpp>

using json = nlohmann::json;

// ȫֽűʵ
ScriptManager g_script_manager;

// ű캯
ScriptManager::ScriptManager() {
    // ƳĬӵħű
    // AddScript({
    //     "ħ", 
    //     "ִħ·+Shiftͷ", 
    //     'R',  // ĬϰR
    //     ExecuteMagicBurst
    // });

    // رĽű
    LoadScriptConfig();
}

// ӽű
void ScriptManager::AddScript(const Script& script) {
    scripts.push_back(script);
}

// ȡнű
const std::vector<Script>& ScriptManager::GetScripts() const {
    return scripts;
}

// ȡű
Script* ScriptManager::GetScript(size_t index) {
    if (index < scripts.size()) {
        return &scripts[index];
    }
    return nullptr;
}

// ݰȡű
Script* ScriptManager::GetScriptByHotkey(int hotkey) {
    for (auto& script : scripts) {
        if (script.hotkey == hotkey) {
            return &script;
        }
    }
    return nullptr;
}

// ýűȼ
void ScriptManager::SetScriptHotkey(size_t index, int hotkey) {
    if (index < scripts.size()) {
        scripts[index].hotkey = hotkey;
        SaveScriptConfig();
    }
}

// ű
void ScriptManager::SaveScriptConfig() {
    try {
        json j;

        // ű
        json scriptArray = json::array();

        for (size_t i = 0; i < scripts.size(); i++) {
            json scriptObj;

            // űƺȼ
            scriptObj["name"] = scripts[i].name;
            scriptObj["hotkey"] = scripts[i].hotkey;
            // Ҳʶ
            scriptObj["description"] = scripts[i].description;

            scriptArray.push_back(scriptObj);
        }

        j["scripts"] = scriptArray;

        // 浽ļȷʹUTF-8
        std::ofstream file("scripts_config.json", std::ios::out | std::ios::binary);
        if (file.is_open()) {
            std::string jsonStr = j.dump(4);
            file.write("\xEF\xBB\xBF", 3); // дUTF-8 BOM
            file.write(jsonStr.c_str(), jsonStr.length());
            file.close();
        }
        else {
            throw std::runtime_error("޷ļд");
        }
    }
    catch (const std::exception& e) {
        MessageBoxA(NULL, (std::string("ʧ: ") + e.what()).c_str(),
            "ñ", MB_OK | MB_ICONERROR);
    }
}

// ؽű
void ScriptManager::LoadScriptConfig() {
    try {
        std::ifstream file("scripts_config.json", std::ios::in | std::ios::binary);
        if (!file.is_open()) {
            // ļڣµļ
            SaveScriptConfig();
            return;
        }

        // ļǷΪ
        if (file.peek() == std::ifstream::traits_type::eof()) {
            file.close();
            // ļΪգµļ
            SaveScriptConfig();
            return;
        }

        // ⲢUTF-8 BOM
        char bom[3];
        if (file.read(bom, 3) && !(bom[0] == (char)0xEF && bom[1] == (char)0xBB && bom[2] == (char)0xBF)) {
            file.seekg(0); // ûBOMļָ뵽ͷ
        }

        // ȡļݵַ
        std::string jsonContent((std::istreambuf_iterator<char>(file)), std::istreambuf_iterator<char>());
        file.close();

        // ǷΪ
        if (jsonContent.empty()) {
            SaveScriptConfig();
            return;
        }

        // JSON
        json j = json::parse(jsonContent);

        if (j.contains("scripts") && j["scripts"].is_array()) {
            json scriptArray = j["scripts"];

            // һӳ䣬ڴ洢űƵȼӳ
            std::unordered_map<std::string, int> scriptHotkeys;

            // ȴļжȡнűȼ
            for (const auto& scriptObj : scriptArray) {
                if (scriptObj.contains("name") && scriptObj.contains("hotkey")) {
                    std::string name = scriptObj["name"];
                    int hotkey = scriptObj["hotkey"];
                    scriptHotkeys[name] = hotkey;
                }
            }

            // ȻӦõǰűб
            for (auto& script : scripts) {
                // ҵ˶ӦƵĽűӦȼ
                auto it = scriptHotkeys.find(script.name);
                if (it != scriptHotkeys.end()) {
                    script.hotkey = it->second;
                }
            }
        }
    }
    catch (const json::exception& e) {
        // رJSON
        std::string errorMsg = "JSON: ";
        errorMsg += e.what();
        MessageBoxA(NULL, errorMsg.c_str(), "üش", MB_OK | MB_ICONERROR);
        // ɾ𻵵ļ
        DeleteFileA("scripts_config.json");
        // µļ
        SaveScriptConfig();
    }
    catch (const std::exception& e) {
        // 쳣
        std::string errorMsg = "ʧ: ";
        errorMsg += e.what();
        MessageBoxA(NULL, errorMsg.c_str(), "üش", MB_OK | MB_ICONERROR);
        // ʧܣʹĬֵ
        SaveScriptConfig();
    }
}

// нű
void ScriptManager::ClearScripts() {
    // ֱнűҪһ
    scripts.clear();
}

// ɾȫֱĶ壬ΪѾ main.cpp ж
// bool g_tool_enabled = false;
// bool g_is_executing = false;
// std::mutex g_execution_lock;

// ģ⺯ʵ
void SimulateKeyPress(WORD vkCode) {
    UINT scanCode;
    DWORD flags = 0;

    // ⴦EnterĬʹСEnter
    if (vkCode == VK_RETURN) {
        scanCode = 0x1C;  // СEnterɨ
        flags = KEYEVENTF_EXTENDEDKEY;  // Ϊչ
    }
    else {
        scanCode = MapVirtualKey(vkCode, MAPVK_VK_TO_VSC);
        // չĴ
        if (vkCode == VK_LEFT || vkCode == VK_RIGHT || vkCode == VK_UP || vkCode == VK_DOWN ||
            vkCode == VK_HOME || vkCode == VK_END || vkCode == VK_PRIOR || vkCode == VK_NEXT ||
            vkCode == VK_INSERT || vkCode == VK_DELETE)
            flags |= KEYEVENTF_EXTENDEDKEY;
    }

    keybd_event(static_cast<BYTE>(vkCode), static_cast<BYTE>(scanCode), flags, 0);
}

void SimulateKeyRelease(WORD vkCode) {
    UINT scanCode;
    DWORD flags = KEYEVENTF_KEYUP;

    // ⴦EnterĬʹСEnter
    if (vkCode == VK_RETURN) {
        scanCode = 0x1C;  // СEnterɨ
        flags |= KEYEVENTF_EXTENDEDKEY;  // Ϊչ
    }
    else {
        scanCode = MapVirtualKey(vkCode, MAPVK_VK_TO_VSC);
        // չĴ
        if (vkCode == VK_LEFT || vkCode == VK_RIGHT || vkCode == VK_UP || vkCode == VK_DOWN ||
            vkCode == VK_HOME || vkCode == VK_END || vkCode == VK_PRIOR || vkCode == VK_NEXT ||
            vkCode == VK_INSERT || vkCode == VK_DELETE)
            flags |= KEYEVENTF_EXTENDEDKEY;
    }

    keybd_event(static_cast<BYTE>(vkCode), static_cast<BYTE>(scanCode), flags, 0);
}

void SleepFor(double seconds) {
    std::this_thread::sleep_for(std::chrono::milliseconds(static_cast<int>(seconds * 1000)));
}

// ħűʵ
void ExecuteMagicBurst() {
    std::lock_guard<std::mutex> lock(g_execution_lock);
    if (g_is_executing) return;
    g_is_executing = true;

    try {
        // ס
        SimulateKeyPress(g_keys.move_down_key);
        SleepFor(0.2);  // ̶ӳ

        // סShift
        SimulateKeyPress(g_keys.sprint_key);
        SleepFor(0.1);  // ̶ӳ

        // ͷŷ
        SimulateKeyRelease(g_keys.move_down_key);
        SleepFor(0.01);  // ̶ӳ

        // ͷShift
        SimulateKeyRelease(g_keys.sprint_key);

        g_is_executing = false;
    }
    catch (...) {
        // ȷʱͷа
        SimulateKeyRelease(g_keys.move_down_key);
        SimulateKeyRelease(g_keys.sprint_key);
        g_is_executing = false;
    }
}



// űʵ... 