#pragma execution_character_set("utf-8")
#include <Windows.h>
#include <string>
#include <fstream>
#include <nlohmann/json.hpp>

using json = nlohmann::json;

// NBA2KOL2λýṹ
struct NBA2KOL2Keys {
    // λ
    int shoot_key = 'D';          // Ͷ
    int post_up_key = 'W';        // 
    int pass_key = 'S';           // 
    int sprint_key = VK_SHIFT;    // ̼
    int bounce_pass_key = 'E';    // ش
    int lob_pass_key = 'A';       // ߵ
    int post_move_key = 'W';      // 

    // ƶ
    int move_up_key = VK_UP;      // ƶԱ
    int move_down_key = VK_DOWN;  // ƶԱ
    int move_left_key = VK_LEFT;  // ƶԱ
    int move_right_key = VK_RIGHT;// ƶԱ

    // ⷽ
    int special_up_key = 'Z';     // ⷽϼ
    int special_down_key = 'X';   // ⷽ¼
    int special_left_key = 'C';   // ⷽ
    int special_right_key = 'V';  // ⷽҼ

    // бⷽ
    int special_left_up_key = '6';    // ⷽϼ
    int special_left_down_key = '7';  // ⷽ¼
    int special_right_down_key = '8'; // ⷽ¼
    int special_right_up_key = '9';   // ⷽϼ

    // 
    int right_hand_spin_key = '0';    // ֳת
    int left_hand_spin_key = '4';     // ֳת  // Ĭ4
    int right_hand_turn_key = '5';    // ֳת    // Ĭ5
    int left_hand_turn_key = '6';     // ֳת    // Ĭ6
};

// ȫö
extern NBA2KOL2Keys g_keys;

// ӼλԤö
enum class KeyPreset {
    OL_DEFAULT,  // OLĬԤ
    K2_DEFAULT   // 2KĬԤ
};
// õJSONļ
void SaveKeysConfig() {
    json j;

    // λ
    j["shoot_key"] = g_keys.shoot_key;
    j["post_up_key"] = g_keys.post_up_key;
    j["pass_key"] = g_keys.pass_key;
    j["sprint_key"] = g_keys.sprint_key;
    j["bounce_pass_key"] = g_keys.bounce_pass_key;
    j["lob_pass_key"] = g_keys.lob_pass_key;
    j["post_move_key"] = g_keys.post_move_key;

    // ƶ
    j["move_up_key"] = g_keys.move_up_key;
    j["move_down_key"] = g_keys.move_down_key;
    j["move_left_key"] = g_keys.move_left_key;
    j["move_right_key"] = g_keys.move_right_key;

    // ⷽ
    j["special_up_key"] = g_keys.special_up_key;
    j["special_down_key"] = g_keys.special_down_key;
    j["special_left_key"] = g_keys.special_left_key;
    j["special_right_key"] = g_keys.special_right_key;

    // бⷽ
    j["special_left_up_key"] = g_keys.special_left_up_key;
    j["special_left_down_key"] = g_keys.special_left_down_key;
    j["special_right_down_key"] = g_keys.special_right_down_key;
    j["special_right_up_key"] = g_keys.special_right_up_key;

    // 
    j["right_hand_spin_key"] = g_keys.right_hand_spin_key;
    j["left_hand_spin_key"] = g_keys.left_hand_spin_key;
    j["right_hand_turn_key"] = g_keys.right_hand_turn_key;
    j["left_hand_turn_key"] = g_keys.left_hand_turn_key;

    // 浽ļ
    std::ofstream file("nba2kol2_keys.json");
    file << j.dump(4);
}
// лλԤĺ
void SwitchKeyPreset(KeyPreset preset) {
    switch (preset) {
    case KeyPreset::OL_DEFAULT:
        // OLĬԤ
        g_keys.shoot_key = 'D';          // Ͷ
        g_keys.post_up_key = 'W';        // 
        g_keys.pass_key = 'S';           // 
        g_keys.sprint_key = VK_SHIFT;    // ̼
        g_keys.bounce_pass_key = 'E';    // ش
        g_keys.lob_pass_key = 'A';       // ߵ
        g_keys.post_move_key = 'W';      // 
        g_keys.move_up_key = VK_UP;      // ƶ
        g_keys.move_down_key = VK_DOWN;  // ƶ
        g_keys.move_left_key = VK_LEFT;  // ƶ
        g_keys.move_right_key = VK_RIGHT;// ƶ
        g_keys.special_up_key = 'Z';     // ⷽ
        g_keys.special_down_key = 'X';   // ⷽ
        g_keys.special_left_key = 'C';   // ⷽ
        g_keys.special_right_key = 'V';  // ⷽ
        break;

    case KeyPreset::K2_DEFAULT:
        // 2KĬԤ
        g_keys.shoot_key = VK_NUMPAD5;   // ͶС5
        g_keys.post_up_key = VK_LSHIFT;  // Shift
        g_keys.pass_key = VK_SPACE;      // ո
        g_keys.sprint_key = VK_RETURN;   // ̼Enter
        g_keys.bounce_pass_key = VK_NUMPAD1; // شС1
        g_keys.lob_pass_key = VK_NUMPAD3;    // ߵС3
        g_keys.post_move_key = VK_LSHIFT;    // Shift
        g_keys.move_up_key = 'W';        // ƶW
        g_keys.move_down_key = 'S';      // ƶS
        g_keys.move_left_key = 'A';      // ƶA
        g_keys.move_right_key = 'D';     // ƶD
        g_keys.special_up_key = VK_NUMPAD8;   // ⷽϣС8
        g_keys.special_down_key = VK_NUMPAD2; // ⷽ£С2
        g_keys.special_left_key = VK_NUMPAD4; // ⷽС4
        g_keys.special_right_key = VK_NUMPAD6;// ⷽңС6
        break;
    }

    // µļλ
    SaveKeysConfig();
}



// JSONļ
void LoadKeysConfig() {
    try {
        std::ifstream file("nba2kol2_keys.json");
        if (file.is_open()) {
            json j;
            file >> j;

            // λ
            g_keys.shoot_key = j["shoot_key"];
            g_keys.post_up_key = j["post_up_key"];
            g_keys.pass_key = j["pass_key"];
            g_keys.sprint_key = j["sprint_key"];
            g_keys.bounce_pass_key = j["bounce_pass_key"];
            g_keys.lob_pass_key = j["lob_pass_key"];
            g_keys.post_move_key = j["post_move_key"];

            // ƶ
            g_keys.move_up_key = j["move_up_key"];
            g_keys.move_down_key = j["move_down_key"];
            g_keys.move_left_key = j["move_left_key"];
            g_keys.move_right_key = j["move_right_key"];

            // ⷽ
            g_keys.special_up_key = j["special_up_key"];
            g_keys.special_down_key = j["special_down_key"];
            g_keys.special_left_key = j["special_left_key"];
            g_keys.special_right_key = j["special_right_key"];

            // бⷽ
            g_keys.special_left_up_key = j["special_left_up_key"];
            g_keys.special_left_down_key = j["special_left_down_key"];
            g_keys.special_right_down_key = j["special_right_down_key"];
            g_keys.special_right_up_key = j["special_right_up_key"];

            // 
            g_keys.right_hand_spin_key = j["right_hand_spin_key"];
            g_keys.left_hand_spin_key = j["left_hand_spin_key"];
            g_keys.right_hand_turn_key = j["right_hand_turn_key"];
            g_keys.left_hand_turn_key = j["left_hand_turn_key"];
        }
    }
    catch (...) {
        // ʧܣʹĬֵ
        SaveKeysConfig();
    }
}

// һڿַת
std::string WideToUtf8(const std::wstring& wstr) {
    if (wstr.empty()) return std::string();
    int size_needed = WideCharToMultiByte(CP_UTF8, 0, &wstr[0], (int)wstr.size(), NULL, 0, NULL, NULL);
    std::string strTo(size_needed, 0);
    WideCharToMultiByte(CP_UTF8, 0, &wstr[0], (int)wstr.size(), &strTo[0], size_needed, NULL, NULL);
    return strTo;
}

// е WideToUtf8  Utf8ToWide ʵ
std::wstring Utf8ToWide(const std::string& utf8Str) {
    if (utf8Str.empty()) return std::wstring();
    int size_needed = MultiByteToWideChar(CP_UTF8, 0, utf8Str.c_str(), -1, NULL, 0);
    std::wstring wstrTo(size_needed, 0);
    MultiByteToWideChar(CP_UTF8, 0, utf8Str.c_str(), -1, &wstrTo[0], size_needed);
    // ȥβnullַ
    if (!wstrTo.empty() && wstrTo.back() == 0) {
        wstrTo.pop_back();
    }
    return wstrTo;
}

// ȡ
std::string GetKeyName(int vkCode) {
    switch (vkCode) {
    case VK_LEFT: return "";    // ʹַ
    case VK_RIGHT: return "";   // ʹַ
    case VK_UP: return "";      // ʹַ
    case VK_DOWN: return "";    // ʹַ
    case VK_SHIFT: return "Shift";
    case VK_CONTROL: return "Ctrl";
    case VK_MENU: return "Alt";
    case VK_TAB: return "Tab";
    case VK_SPACE: return "ո";  // Ҳ
    case VK_RETURN: return "س";  // Ҳ
    case VK_BACK: return "˸";    // Ҳ
    case VK_DELETE: return "ɾ";   // Ҳ
    case VK_INSERT: return "";   // Ҳ
    case VK_HOME: return "Home";
    case VK_END: return "End";
    case VK_PRIOR: return "ҳ";    // Ҳ
    case VK_NEXT: return "ҳ";     // Ҳ
    case VK_ESCAPE: return "Esc";
    default:
        if (vkCode >= '0' && vkCode <= '9') {
            return std::string(1, (char)vkCode);
        }
        else if (vkCode >= 'A' && vkCode <= 'Z') {
            return std::string(1, (char)(vkCode));
        }
        else {
            char keyName[32];
            UINT scanCode = MapVirtualKey(vkCode, MAPVK_VK_TO_VSC);
            if (scanCode > 0) {
                GetKeyNameTextA(scanCode << 16, keyName, sizeof(keyName));
                return std::string(keyName);
            }
            return "δ֪";  // Ҳ
        }
    }
}

// ʼĬϼλ
NBA2KOL2Keys g_keys = {
    'D',        // shoot_key
    'W',        // post_up_key
    'S',        // pass_key
    VK_SHIFT,   // sprint_key
    'E',        // bounce_pass_key
    'A',        // lob_pass_key
    'W',        // post_move_key
    VK_UP,      // move_up_key
    VK_DOWN,    // move_down_key
    VK_LEFT,    // move_left_key
    VK_RIGHT,   // move_right_key
    'Z',        // special_up_key
    'X',        // special_down_key
    'C',        // special_left_key
    'V',        // special_right_key
    '6',        // special_left_up_key
    '7',        // special_left_down_key
    '8',        // special_right_down_key
    '9',        // special_right_up_key
    '0',        // right_hand_spin_key
    '4',        // left_hand_spin_key   // Ĭ4
    '5',        // right_hand_turn_key  // Ĭ5
    '6'         // left_hand_turn_key   // Ĭ6
};
