#pragma execution_character_set("utf-8")

#include "imgui/license_verifier.h"
#include <windows.h>
#include <iostream>
#include <sstream>
#include <curl/curl.h>
#include <fstream>
#include <nlohmann/json.hpp>
#include <ctime>
#include <iomanip>

using json = nlohmann::json;

// ʣʱĸ
int CalculateRemainingDays(const std::string& endTimeStr) {
    try {
        // ʱַ (ʽΪ "YYYY-MM-DD HH:MM:SS"  "YYYY-MM-DD")
        std::tm tm = {};
        std::istringstream ss(endTimeStr);

        if (endTimeStr.length() >= 10) {
            // ڲ YYYY-MM-DD
            ss >> tm.tm_year >> std::get_time(&tm, "-") >> tm.tm_mon >> std::get_time(&tm, "-") >> tm.tm_mday;
            tm.tm_year -= 1900;  // tm_year Ǵ1900꿪ʼ
            tm.tm_mon -= 1;      // tm_mon 0-11

            // ʱ䲿֣ʱ
            if (endTimeStr.length() > 10) {
                ss >> std::get_time(&tm, " ") >> tm.tm_hour >> std::get_time(&tm, ":") >> tm.tm_min >> std::get_time(&tm, ":") >> tm.tm_sec;
            }
        }

        // תΪʱ
        std::time_t endTime = std::mktime(&tm);
        if (endTime == -1) {
            return -1;  // ʧ
        }

        // ȡǰʱ
        std::time_t now = std::time(nullptr);

        // ʣ
        std::time_t remaining = endTime - now;

        // תΪ
        int days = static_cast<int>(remaining / (24 * 3600));

        return days;
    }
    catch (const std::exception& e) {
        std::cout << "ʣʱʧ: " << e.what() << std::endl;
        return -1;
    }
}

// ʣʱַ
std::string GenerateRemainingTimeStr(int days) {
    if (days < 0) {
        return "ѹ";
    }
    else if (days == 0) {
        return "쵽";
    }
    else if (days == 1) {
        return "쵽";
    }
    else if (days < 7) {
        return "ʣ " + std::to_string(days) + " ";
    }
    else if (days < 30) {
        int weeks = days / 7;
        int remainingDays = days % 7;
        if (remainingDays == 0) {
            return "ʣ " + std::to_string(weeks) + " ";
        }
        else {
            return "ʣ " + std::to_string(weeks) + "  " + std::to_string(remainingDays) + " ";
        }
    }
    else if (days < 365) {
        int months = days / 30;
        int remainingDays = days % 30;
        if (remainingDays == 0) {
            return "ʣ " + std::to_string(months) + " ";
        }
        else {
            return "ʣ " + std::to_string(months) + "  " + std::to_string(remainingDays) + " ";
        }
    }
    else {
        int years = days / 365;
        int remainingDays = days % 365;
        if (remainingDays == 0) {
            return "ʣ " + std::to_string(years) + " ";
        }
        else {
            return "ʣ " + std::to_string(years) + "  " + std::to_string(remainingDays) + " ";
        }
    }
}

// صΪȫֺ
static size_t CurlWriteCallback(void* contents, size_t size, size_t nmemb, void* userp) {
    std::string* str = static_cast<std::string*>(userp);
    size_t totalSize = size * nmemb;
    str->append(static_cast<const char*>(contents), totalSize);
    return totalSize;
}

// ļ·
const std::string MACHINE_CODE_FILE = "C:\\2kyq\\machine.json";  // ļ

bool LicenseVerifier::Initialize() {
    // ÿ̨ҳΪ UTF-8
    SetConsoleOutputCP(65001);
    // ÿ̨Ϊ֧ĵ
    CONSOLE_FONT_INFOEX cfi;
    cfi.cbSize = sizeof(cfi);
    cfi.nFont = 0;
    cfi.dwFontSize.X = 0;
    cfi.dwFontSize.Y = 16;
    cfi.FontFamily = FF_DONTCARE;
    cfi.FontWeight = FW_NORMAL;
    wcscpy_s(cfi.FaceName, L"");
    SetCurrentConsoleFontEx(GetStdHandle(STD_OUTPUT_HANDLE), FALSE, &cfi);

    // ʼCURL
    curl_global_init(CURL_GLOBAL_DEFAULT);
    return true;
}

std::string LicenseVerifier::GetMachineCode() {
    // Դļȡ
    try {
        std::ifstream file(MACHINE_CODE_FILE);
        if (file.is_open()) {
            json j;
            file >> j;
            file.close();

            if (j.contains("machine_code")) {
                std::string machineCode = j["machine_code"].get<std::string>();
                std::cout << "֤ӻػ: " << machineCode << std::endl;
                return machineCode;
            }
        }
    }
    catch (const std::exception& e) {
        std::cout << "֤ػʧ: " << e.what() << std::endl;
    }

    // ޷ȡļؼݾ߼
    char computerName[MAX_COMPUTERNAME_LENGTH + 1];
    DWORD size = sizeof(computerName);
    if (GetComputerNameA(computerName, &size)) {
        std::cout << ": ʹüΪ: " << computerName << std::endl;
        return std::string(computerName);
    }
    return "UNKNOWN";
}

LicenseInfo LicenseVerifier::VerifyLicense(const std::string& keyCode, int softwareId) {
    CURL* curl = curl_easy_init();
    LicenseInfo result;
    result.valid = false;
    result.software_id = softwareId;
    result.key_code = keyCode;

    if (curl) {
        std::string machineCode = GetMachineCode();

        // ӡ֤ϢοPythonʾʽ
        std::cout << "\n֤֤..." << std::endl;
        std::cout << ": " << machineCode << std::endl;
        std::cout << "ID: " << softwareId << std::endl;
        std::cout << "֤Կ: " << keyCode << std::endl;

        // JSON壨Python뱣һµֶ
        std::stringstream jsonData;
        jsonData << "{"
            << "\"key_code\":\"" << keyCode << "\","    // ʹ key_code
            << "\"software_id\":" << softwareId << ","  // ʹ software_id
            << "\"device_code\":\"" << machineCode << "\""  // ʹ device_code
            << "}";

        std::string postData = jsonData.str();
        std::string readBuffer;
        std::string url = "http://117.72.182.10:8080/api/license/verify";  // PythonʹͬURL

        // CURLѡ
        curl_easy_setopt(curl, CURLOPT_URL, url.c_str());
        curl_easy_setopt(curl, CURLOPT_POST, 1L);
        curl_easy_setopt(curl, CURLOPT_POSTFIELDS, postData.c_str());
        curl_easy_setopt(curl, CURLOPT_POSTFIELDSIZE, postData.length());
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, CurlWriteCallback);
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, &readBuffer);
        curl_easy_setopt(curl, CURLOPT_TIMEOUT, 5L);

        // ͷPythonһ£
        struct curl_slist* headers = NULL;
        headers = curl_slist_append(headers, "Content-Type: application/json");
        headers = curl_slist_append(headers, "Accept: application/json");
        curl_easy_setopt(curl, CURLOPT_HTTPHEADER, headers);

        // ӡϢ
        std::cout << ": " << postData << std::endl;
        std::cout << "ӷ..." << std::endl;

        CURLcode res = curl_easy_perform(curl);

        if (res == CURLE_OK) {
            long response_code;
            curl_easy_getinfo(curl, CURLINFO_RESPONSE_CODE, &response_code);

            // PythonĴ߼жӦ
            if (response_code == 200) {
                // ԽJSONӦ
                if (!readBuffer.empty()) {
                    std::cout << "֤ɹ֤Ч" << std::endl;
                    std::cout << "Ӧ: " << readBuffer << std::endl;
                    result.valid = true;

                    // ԽӦJSONȡϸϢ
                    try {
                        json responseJson = json::parse(readBuffer);
                        std::cout << "JSONӦ: " << responseJson.dump(2) << std::endl;

                        if (responseJson.contains("message")) {
                            result.message = responseJson["message"].get<std::string>();
                            std::cout << "Ϣ: " << result.message << std::endl;
                        }

                        // ǷǶ׵license
                        if (responseJson.contains("license") && responseJson["license"].is_object()) {
                            json licenseObj = responseJson["license"];
                            std::cout << "ҵǶ׵license" << std::endl;

                            if (licenseObj.contains("start_time")) {
                                result.start_time = licenseObj["start_time"].get<std::string>();
                                std::cout << "ÿʼʱ: " << result.start_time << std::endl;
                            }
                            if (licenseObj.contains("end_time")) {
                                result.end_time = licenseObj["end_time"].get<std::string>();
                                std::cout << "ýʱ: " << result.end_time << std::endl;

                                // ʣʱ
                                result.remaining_days = CalculateRemainingDays(result.end_time);
                                result.remaining_time_str = GenerateRemainingTimeStr(result.remaining_days);

                                std::cout << "֤ʣʱ: " << result.remaining_time_str << std::endl;
                            }
                            if (licenseObj.contains("start_count")) {
                                result.start_count = licenseObj["start_count"].get<int>();
                                std::cout << ": " << result.start_count << std::endl;
                            }
                        }
                        // ݾɸʽֱӼֶ
                        else {
                            std::cout << "ʹøֶ" << std::endl;
                            if (responseJson.contains("start_time")) {
                                result.start_time = responseJson["start_time"].get<std::string>();
                                std::cout << "ÿʼʱ: " << result.start_time << std::endl;
                            }
                            if (responseJson.contains("end_time")) {
                                result.end_time = responseJson["end_time"].get<std::string>();
                                std::cout << "ýʱ: " << result.end_time << std::endl;

                                // ʣʱ
                                result.remaining_days = CalculateRemainingDays(result.end_time);
                                result.remaining_time_str = GenerateRemainingTimeStr(result.remaining_days);

                                std::cout << "֤ʣʱ: " << result.remaining_time_str << std::endl;
                            }
                            if (responseJson.contains("start_count")) {
                                result.start_count = responseJson["start_count"].get<int>();
                                std::cout << ": " << result.start_count << std::endl;
                            }
                        }

                        std::cout << "ս - ʼʱ: " << result.start_time
                            << ", ʱ: " << result.end_time
                            << ", ʣʱ: " << result.remaining_time_str
                            << ", : " << result.start_count << std::endl;
                    }
                    catch (const std::exception& e) {
                        std::cout << "ӦJSONʧ: " << e.what() << std::endl;
                    }
                }
            }
            else if (response_code == 404) {
                std::cout << ": " << readBuffer << std::endl;
                try {
                    json err = json::parse(readBuffer);
                    if (err.contains("message")) {
                        result.message = err["message"].get<std::string>();
                    }
                    else {
                        result.message = "ܲڻڴ";
                    }
                }
                catch (...) {
                    result.message = "ܲڻڴ";
                }
            }
            else if (response_code == 403) {
                std::cout << ": " << readBuffer << std::endl;
                try {
                    json err = json::parse(readBuffer);
                    if (err.contains("message")) {
                        result.message = err["message"].get<std::string>();
                    }
                    else {
                        result.message = readBuffer;
                    }
                }
                catch (...) {
                    result.message = readBuffer;
                }
            }
            else {
                std::cout << "֤ʧܣ֤Ч" << std::endl;
                std::cout << ": " << response_code << std::endl;
                std::cout << "Ӧ: " << readBuffer << std::endl;
                try {
                    json err = json::parse(readBuffer);
                    if (err.contains("message")) {
                        result.message = err["message"].get<std::string>();
                    }
                    else {
                        result.message = "֤ʧܣ: " + std::to_string(response_code);
                    }
                }
                catch (...) {
                    result.message = "֤ʧܣ: " + std::to_string(response_code);
                }
            }
        }
        else {
            std::cout << "ӷʧܣ" << std::endl;
            std::cout << "Ϣ: " << curl_easy_strerror(res) << std::endl;
            result.message = "ӷʧ: " + std::string(curl_easy_strerror(res));
        }

        // 
        curl_slist_free_all(headers);
        curl_easy_cleanup(curl);
    }
    else {
        std::cout << "ʼCURLʧܣ" << std::endl;
    }

    return result;
}