#include "utils.h"
#include <fstream>
#include <iomanip>
#include <ShlObj.h>
#include <direct.h>
#include <curl/curl.h>
#include <iostream>
#include <sstream>

// ļ·Ϊ̶CĿ¼
const char* CONFIG_DIR = "C:\\FXKOLCPP";
const char* CONFIG_FILE = "C:\\FXKOLCPP\\dunk_config.json";
Config g_config;
std::mutex g_dunking_lock;
bool g_is_dunking = false;
bool g_shortcut_pressed = false;
bool g_tool_enabled = true;
std::string g_selected_key_name;
int g_selected_key = 0;
SoftwareInfo g_software_info;  // ʼϢȫֱ

// CURLص
static size_t WriteCallback(void* contents, size_t size, size_t nmemb, void* userp) {
    ((std::string*)userp)->append((char*)contents, size * nmemb);
    return size * nmemb;
}

void CreateConfigDir() {
    // ȷĿ¼
    _mkdir(CONFIG_DIR);
}

void SaveConfig() {
    CreateConfigDir(); // ȷĿ¼

    json j;
    j["dunk_key_1"] = g_config.dunk_key_1;
    j["dunk_key_2"] = g_config.dunk_key_2;
    j["shortcut_key"] = g_config.shortcut_key;
    j["tool_toggle_key"] = g_config.tool_toggle_key;
    j["boost_key"] = g_config.boost_key;
    j["dunk_type_toggle_key"] = g_config.dunk_type_toggle_key;
    j["tool_enabled"] = g_tool_enabled;
    j["dunk_type"] = g_config.dunk_type;

    std::ofstream o(CONFIG_FILE);
    o << std::setw(4) << j << std::endl;
}

void LoadConfig() {
    try {
        // ȷĬ
        // ȻԼļڵĻ
        g_config = Config(); // Ĭֵ

        std::ifstream i(CONFIG_FILE);
        if (i.is_open()) {
            json j;
            i >> j;

            // ʹvalueڼʱʹĬֵ
            g_config.dunk_key_1 = j.value("dunk_key_1", g_config.dunk_key_1);
            g_config.dunk_key_2 = j.value("dunk_key_2", g_config.dunk_key_2);
            g_config.shortcut_key = j.value("shortcut_key", g_config.shortcut_key);
            g_config.tool_toggle_key = j.value("tool_toggle_key", g_config.tool_toggle_key);
            g_config.boost_key = j.value("boost_key", g_config.boost_key);
            g_config.dunk_type_toggle_key = j.value("dunk_type_toggle_key", g_config.dunk_type_toggle_key);
            g_tool_enabled = j.value("tool_enabled", true);
            g_config.dunk_type = j.value("dunk_type", "single");
        }
        else {
            // ļڣĬ
            SaveConfig();
        }
    }
    catch (...) {
        // κδʹĬ
        g_config = Config();
        // Ĭõļ
        SaveConfig();
    }
}

void SimulateKeyPress(WORD vkCode) {
    UINT scanCode;
    DWORD flags = 0;

    // ⴦EnterĬʹСEnter
    if (vkCode == VK_RETURN) {
        scanCode = 0x1C;  // СEnterɨ
        flags = KEYEVENTF_EXTENDEDKEY;  // Ϊչ
    }
    else {
        scanCode = MapVirtualKey(vkCode, MAPVK_VK_TO_VSC);
    }

    keybd_event(static_cast<BYTE>(vkCode), static_cast<BYTE>(scanCode), flags, 0);
}

void SimulateKeyRelease(WORD vkCode) {
    UINT scanCode;
    DWORD flags = KEYEVENTF_KEYUP;

    // ⴦EnterĬʹСEnter
    if (vkCode == VK_RETURN) {
        scanCode = 0x1C;  // СEnterɨ
        flags |= KEYEVENTF_EXTENDEDKEY;  // Ϊչ
    }
    else {
        scanCode = MapVirtualKey(vkCode, MAPVK_VK_TO_VSC);
    }

    keybd_event(static_cast<BYTE>(vkCode), static_cast<BYTE>(scanCode), flags, 0);
}

void SimulateKeyPressVirtualKey(WORD vkCode) {
    UINT scanCode = MapVirtualKey(vkCode, MAPVK_VK_TO_VSC);
    keybd_event(static_cast<BYTE>(vkCode), static_cast<BYTE>(scanCode), 0, 0);
    Sleep(50);
    keybd_event(static_cast<BYTE>(vkCode), static_cast<BYTE>(scanCode), KEYEVENTF_KEYUP, 0);
}

std::string GetKeyName(WORD vkCode) {
    char keyName[32];
    UINT scanCode = MapVirtualKey(vkCode, MAPVK_VK_TO_VSC);
    GetKeyNameTextA(scanCode << 16, keyName, sizeof(keyName));
    return std::string(keyName);
}

bool IsAdmin() {
    BOOL isAdmin = FALSE;
    PSID adminGroup;
    SID_IDENTIFIER_AUTHORITY ntAuthority = SECURITY_NT_AUTHORITY;

    if (AllocateAndInitializeSid(&ntAuthority, 2, SECURITY_BUILTIN_DOMAIN_RID,
        DOMAIN_ALIAS_RID_ADMINS, 0, 0, 0, 0, 0, 0, &adminGroup)) {
        CheckTokenMembership(NULL, adminGroup, &isAdmin);
        FreeSid(adminGroup);
    }

    return isAdmin == TRUE;
}

// HTTP POSTʵ
std::string HttpPost(const std::string& url, const std::string& jsonData) {
    std::string readBuffer;
    CURL* curl = curl_easy_init();

    if (curl) {
        struct curl_slist* headers = NULL;
        headers = curl_slist_append(headers, "Content-Type: application/json");
        headers = curl_slist_append(headers, "Accept: application/json");

        curl_easy_setopt(curl, CURLOPT_URL, url.c_str());
        curl_easy_setopt(curl, CURLOPT_HTTPHEADER, headers);
        curl_easy_setopt(curl, CURLOPT_POSTFIELDS, jsonData.c_str());
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, &readBuffer);
        curl_easy_setopt(curl, CURLOPT_TIMEOUT, 5L);

        CURLcode res = curl_easy_perform(curl);
        if (res != CURLE_OK) {
            std::cerr << "HTTPʧ: " << curl_easy_strerror(res) << std::endl;
            readBuffer = "{\"error\": \"ӷʧ\"}";
        }

        curl_slist_free_all(headers);
        curl_easy_cleanup(curl);
    }

    return readBuffer;
}

// HTTP GETʵ
std::string HttpGet(const std::string& url) {
    std::string readBuffer;
    CURL* curl = curl_easy_init();

    if (curl) {
        struct curl_slist* headers = NULL;
        headers = curl_slist_append(headers, "Accept: application/json");

        curl_easy_setopt(curl, CURLOPT_URL, url.c_str());
        curl_easy_setopt(curl, CURLOPT_HTTPHEADER, headers);
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, &readBuffer);
        curl_easy_setopt(curl, CURLOPT_TIMEOUT, 5L);

        CURLcode res = curl_easy_perform(curl);
        if (res != CURLE_OK) {
            std::cerr << "HTTPʧ: " << curl_easy_strerror(res) << std::endl;
            readBuffer = "{\"error\": \"ӷʧ\"}";
        }

        curl_slist_free_all(headers);
        curl_easy_cleanup(curl);
    }

    return readBuffer;
}

// ȡϢ
bool GetSoftwareInfo(int softwareId) {
    std::string url = "http://117.72.182.10:8080/api/software/" + std::to_string(softwareId);

    std::string response = HttpGet(url);
    if (response.empty() || response.find("error") != std::string::npos) {
        std::cerr << "ȡϢʧ" << std::endl;
        return false;
    }

    try {
        json responseJson = json::parse(response);

        g_software_info.id = responseJson["id"];
        g_software_info.name = responseJson["name"];
        g_software_info.version = responseJson["version"];
        g_software_info.announcement = responseJson["announcement"];

        return true;
    }
    catch (const std::exception& e) {
        std::cerr << "Ϣʧ: " << e.what() << std::endl;
        return false;
    }
}

// ֤
bool VerifyLicenseOnline(const std::string& keyCode, int softwareId, const std::string& deviceCode) {
    json requestData;
    requestData["key_code"] = keyCode;
    requestData["software_id"] = softwareId;
    requestData["device_code"] = deviceCode;

    std::string jsonData = requestData.dump();
    std::string url = "http://117.72.182.10:8080/api/license/verify";

    std::string response = HttpPost(url, jsonData);
    if (response.empty()) {
        std::cerr << "֤ʧ: δյӦ" << std::endl;
        return false;
    }

    try {
        json responseJson = json::parse(response);

        if (responseJson.contains("valid") && responseJson["valid"].get<bool>()) {
            return true;
        }
        else {
            std::string errorMsg = "֤ʧ";
            if (responseJson.contains("message")) {
                errorMsg = responseJson["message"];
            }
            std::cerr << "֤ʧ: " << errorMsg << std::endl;
            return false;
        }
    }
    catch (const std::exception& e) {
        std::cerr << "֤Ӧʧ: " << e.what() << std::endl;
        return false;
    }
}

// רEnterĺ
void SimulateMainKeyboardEnterPress() {
    UINT scanCode = MapVirtualKey(VK_RETURN, MAPVK_VK_TO_VSC);
    keybd_event(static_cast<BYTE>(VK_RETURN), static_cast<BYTE>(scanCode), 0, 0);
}

void SimulateMainKeyboardEnterRelease() {
    UINT scanCode = MapVirtualKey(VK_RETURN, MAPVK_VK_TO_VSC);
    keybd_event(static_cast<BYTE>(VK_RETURN), static_cast<BYTE>(scanCode), KEYEVENTF_KEYUP, 0);
}
