#pragma execution_character_set("utf-8")

#pragma ocen

#pragma comment(linker, "/subsystem:windows /ENTRY:mainCRTStartup")
#pragma comment(lib, "d3d11.lib")
#pragma comment(lib, "dxgi.lib")
#pragma comment(lib, "d3dcompiler.lib")

#include <Windows.h>
#include <string>
#include <map>
#include <memory>
#include <fstream>
#include <thread>
#include <mutex>
#include <iostream>
#include "imgui/imgui.h"
#include "imgui/imgui_impl_win32.h"
#include "imgui/imgui_impl_dx11.h"
#include <d3d11.h>
#include <nlohmann/json.hpp>
#include "utils.h"
#include "imgui/license_verifier.h"
#include "imgui/license_window.h"

// includeֺ
extern IMGUI_IMPL_API LRESULT ImGui_ImplWin32_WndProcHandler(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

// ӴڴС
static UINT g_ResizeWidth = 0, g_ResizeHeight = 0;

// Զ崰ڹ̺
LRESULT WINAPI WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) {
    if (ImGui_ImplWin32_WndProcHandler(hWnd, msg, wParam, lParam))
        return true;

    switch (msg) {
    case WM_SIZE:
        if (wParam == SIZE_MINIMIZED)
            return 0;
        g_ResizeWidth = (UINT)LOWORD(lParam); // ³ߴ
        g_ResizeHeight = (UINT)HIWORD(lParam);
        return 0;
    case WM_SYSCOMMAND:
        if ((wParam & 0xfff0) == SC_KEYMENU) // ALTӦó˵
            return 0;
        break;
    case WM_DESTROY:
        PostQuitMessage(0);
        return 0;
    }
    return DefWindowProc(hWnd, msg, wParam, lParam);
}

using json = nlohmann::json;

// ȫֱ
// ƳЩȫֱutils.h
// const char* CONFIG_FILE = "dunk_config.json";
// std::mutex g_dunking_lock;
// bool g_is_dunking = false;
// bool g_shortcut_pressed = false;
// bool g_tool_enabled = true;

// ɾConfigṹĶ壬utils.hж

// ɾȫöĶ壬utils.h
// Config g_config;
// std::string g_selected_key_name;
// int g_selected_key = 0;

// 
class DunkAssistant {
private:
    bool m_running;
    std::thread m_hook_thread;

public:
    DunkAssistant() : m_running(false) {}

    void Start() {
        if (!m_running) {
            m_running = true;
            m_hook_thread = std::thread(&DunkAssistant::KeyboardHookProc, this);
        }
    }

    void Stop() {
        if (m_running) {
            m_running = false;
            if (m_hook_thread.joinable()) {
                m_hook_thread.join();
            }
        }
    }

    // ̹Ӵ
    void KeyboardHookProc() {
        while (m_running) {
            // ۹Ƿã鹤߿ؼ
            if (GetAsyncKeyState(g_config.tool_toggle_key) & 0x8000) {
                OnToolTogglePress();
            }

            // ֻڹʱżܼ
            if (g_tool_enabled) {
                // ݼ
                if (GetAsyncKeyState(g_config.shortcut_key) & 0x8000) {
                    OnShortcutPress();
                }
                else {
                    OnShortcutRelease();
                }

                // л
                if (GetAsyncKeyState(g_config.dunk_type_toggle_key) & 0x8000) {
                    OnDunkTypeTogglePress();
                }
            }

            Sleep(1); // CPUʹ
        }
    }

private:
    void OnShortcutPress() {
        if (!g_shortcut_pressed) {
            g_shortcut_pressed = true;

            // ¼ټ
            SimulateKeyPress(g_config.boost_key);

            // ִп
            DunkAction();
        }
    }

    void OnShortcutRelease() {
        if (g_shortcut_pressed) {
            g_shortcut_pressed = false;

            // ͷżټ
            SimulateKeyRelease(g_config.boost_key);
        }
    }

    void OnToolTogglePress() {
        static bool key_pressed = false;
        if (!key_pressed) {
            key_pressed = true;
            g_tool_enabled = !g_tool_enabled;
            SaveConfig();
        }
        Sleep(200); // ֹظ
        key_pressed = false;
    }

    void OnDunkTypeTogglePress() {
        static bool key_pressed = false;
        if (!key_pressed) {
            key_pressed = true;
            g_config.dunk_type = (g_config.dunk_type == "single") ? "double" : "single";
            SaveConfig();
        }
        Sleep(200); // ֹظ
        key_pressed = false;
    }

    void DunkAction() {
        std::lock_guard<std::mutex> lock(g_dunking_lock);
        if (g_is_dunking) return;
        g_is_dunking = true;

        try {
            // ݸѡ񰴼
            int dunk_key = (g_config.dunk_type == "single") ? g_config.dunk_key_1 : g_config.dunk_key_2;

            // ⷽʼg_config.dunk_key_2
            int pull_key = g_config.dunk_key_2;

            // ׶1: ٵۼϼ˫¼
            SimulateKeyPress(dunk_key);
            Sleep(50);  // ʱ
            SimulateKeyRelease(dunk_key);

            // ׶2: ӳ50
            Sleep(50);  // ̶ӳ50

            // ׶3: ݼȻ£ⷽ£
            if (g_shortcut_pressed) {
                SimulateKeyPress(pull_key);

                // ߳ӿݼͷ
                std::thread monitor_thread([this, pull_key]() {
                    // ȴݼͷ
                    while (g_shortcut_pressed) {
                        Sleep(10);  // 10ms
                    }

                    // ݼͷʱͷ
                    SimulateKeyRelease(pull_key);

                    // ÿ״̬
                    {
                        std::lock_guard<std::mutex> lock(g_dunking_lock);
                        g_is_dunking = false;
                    }
                    });

                // Ϊػ߳
                monitor_thread.detach();
            }
            else {
                // ݼͷţÿ״̬
                g_is_dunking = false;
            }
        }
        catch (const std::exception& e) {
            g_is_dunking = false;
        }
        catch (...) {
            g_is_dunking = false;
        }
    }
};

// 
class MainWindow {
private:
    ID3D11Device* m_pd3dDevice = nullptr;
    ID3D11DeviceContext* m_pd3dDeviceContext = nullptr;
    IDXGISwapChain* m_pSwapChain = nullptr;
    ID3D11RenderTargetView* m_mainRenderTargetView = nullptr;
    DunkAssistant m_assistant;
    HWND m_hwnd = nullptr;
    LicenseWindow m_licenseWindow; // ӿ֤
    bool m_show_license_window = true; // ʼʾ֤

    // ӳԱڰ
    std::thread m_key_listening_thread;
    bool m_is_listening_for_key = false;
    int* m_target_key_code = nullptr;
    std::mutex m_key_listening_mutex;

public:
    MainWindow() {}
    ~MainWindow() {
        // ֹͣ߳
        StopKeyListeningThread();

        // ImGui
        ImGui_ImplDX11_Shutdown();
        ImGui_ImplWin32_Shutdown();
        ImGui::DestroyContext();

        // DirectX
        CleanupDeviceD3D();
    }

    bool Initialize(HINSTANCE hInstance) {
        // עᴰ
        WNDCLASSEXW wc = { sizeof(wc) };
        wc.style = CS_CLASSDC;
        wc.lpfnWndProc = WndProc;  // ʹԶWndProc
        wc.hInstance = hInstance;
        wc.lpszClassName = L"DunkAssistant";
        RegisterClassExW(&wc);

        // ȡϢ
        GetSoftwareInfo(3); // IDΪ1

        //  - ʹñ׼ʽޱ߿ʽ
        std::wstring windowTitle = L"2K - " + std::wstring(g_software_info.version.begin(), g_software_info.version.end());
        m_hwnd = CreateWindowW(wc.lpszClassName, windowTitle.c_str(),
            WS_OVERLAPPEDWINDOW, 100, 100, 400, 600,
            nullptr, nullptr, wc.hInstance, nullptr);

        // ʼDirectX
        if (!CreateDeviceD3D(m_hwnd)) {
            CleanupDeviceD3D();
            UnregisterClassW(wc.lpszClassName, wc.hInstance);
            return false;
        }

        // ʾ
        ShowWindow(m_hwnd, SW_SHOWDEFAULT);
        UpdateWindow(m_hwnd);

        // ʼImGui
        IMGUI_CHECKVERSION();
        ImGui::CreateContext();
        ImGuiIO& io = ImGui::GetIO();
        io.ConfigFlags |= ImGuiConfigFlags_NavEnableKeyboard;

        // ImGui϶С
        io.ConfigWindowsMoveFromTitleBarOnly = true;

        // ֧֣ʹGetGlyphRangesChineseSimplifiedCommon()
        io.Fonts->AddFontFromFileTTF("c:\\Windows\\Fonts\\msyh.ttc", 18.0f, NULL, io.Fonts->GetGlyphRangesChineseSimplifiedCommon());

        // ImGui
        ImGui::StyleColorsDark();

        // ʼImGuiƽ̨Ⱦ
        if (!ImGui_ImplWin32_Init(m_hwnd)) {
            return false;
        }
        if (!ImGui_ImplDX11_Init(m_pd3dDevice, m_pd3dDeviceContext)) {
            return false;
        }

        // ʼ״̬Ϊʾ֤
        m_show_license_window = true;

        return true;
    }

    bool CreateDeviceD3D(HWND hWnd) {
        DXGI_SWAP_CHAIN_DESC sd;
        ZeroMemory(&sd, sizeof(sd));
        sd.BufferCount = 2;
        sd.BufferDesc.Width = 0;
        sd.BufferDesc.Height = 0;
        sd.BufferDesc.Format = DXGI_FORMAT_R8G8B8A8_UNORM;
        sd.BufferDesc.RefreshRate.Numerator = 60;
        sd.BufferDesc.RefreshRate.Denominator = 1;
        sd.Flags = DXGI_SWAP_CHAIN_FLAG_ALLOW_MODE_SWITCH;
        sd.BufferUsage = DXGI_USAGE_RENDER_TARGET_OUTPUT;
        sd.OutputWindow = hWnd;
        sd.SampleDesc.Count = 1;
        sd.SampleDesc.Quality = 0;
        sd.Windowed = TRUE;
        sd.SwapEffect = DXGI_SWAP_EFFECT_DISCARD;

        UINT createDeviceFlags = 0;
        D3D_FEATURE_LEVEL featureLevel;
        const D3D_FEATURE_LEVEL featureLevelArray[2] = { D3D_FEATURE_LEVEL_11_0, D3D_FEATURE_LEVEL_10_0, };

        HRESULT hr = D3D11CreateDeviceAndSwapChain(
            nullptr, D3D_DRIVER_TYPE_HARDWARE, nullptr, createDeviceFlags, featureLevelArray, 2,
            D3D11_SDK_VERSION, &sd, &m_pSwapChain, &m_pd3dDevice, &featureLevel, &m_pd3dDeviceContext);

        if (FAILED(hr))
            return false;

        CreateRenderTarget();
        return true;
    }

    void CreateRenderTarget() {
        ID3D11Texture2D* pBackBuffer;
        m_pSwapChain->GetBuffer(0, IID_PPV_ARGS(&pBackBuffer));
        if (pBackBuffer != nullptr) {
            m_pd3dDevice->CreateRenderTargetView(pBackBuffer, nullptr, &m_mainRenderTargetView);
            pBackBuffer->Release();
        }
    }

    void CleanupRenderTarget() {
        if (m_mainRenderTargetView) { m_mainRenderTargetView->Release(); m_mainRenderTargetView = nullptr; }
    }

    void CleanupDeviceD3D() {
        CleanupRenderTarget();
        if (m_pSwapChain) { m_pSwapChain->Release(); m_pSwapChain = nullptr; }
        if (m_pd3dDeviceContext) { m_pd3dDeviceContext->Release(); m_pd3dDeviceContext = nullptr; }
        if (m_pd3dDevice) { m_pd3dDevice->Release(); m_pd3dDevice = nullptr; }
    }

    void RenderFrame() {
        // ڴС
        if (g_ResizeWidth != 0 && g_ResizeHeight != 0) {
            CleanupRenderTarget();
            m_pSwapChain->ResizeBuffers(0, g_ResizeWidth, g_ResizeHeight, DXGI_FORMAT_UNKNOWN, 0);
            g_ResizeWidth = g_ResizeHeight = 0;
            CreateRenderTarget();
        }

        // ʼ֡
        ImGui_ImplDX11_NewFrame();
        ImGui_ImplWin32_NewFrame();
        ImGui::NewFrame();

        // 
        m_pd3dDeviceContext->OMSetRenderTargets(1, &m_mainRenderTargetView, nullptr);
        float clear_color[4] = { 0.45f, 0.55f, 0.60f, 1.00f };
        m_pd3dDeviceContext->ClearRenderTargetView(m_mainRenderTargetView, clear_color);

        // 鿨֤״̬
        if (m_show_license_window) {
            // ʾ֤ڣʾUI
            m_licenseWindow.Render();

            // ֤ɹر֤ڣʾ
            if (m_licenseWindow.IsVerified()) {
                m_show_license_window = false;
                // ʼ
                StartAssistant();
            }
        }
        else {
            // ȾUI
            RenderUI();
        }

        // Ⱦ
        ImGui::Render();
        ImGui_ImplDX11_RenderDrawData(ImGui::GetDrawData());
        m_pSwapChain->Present(1, 0);
    }

    void RenderUI() {
        // ôͻ
        ImGui::SetNextWindowPos(ImVec2(0, 0));
        ImGui::SetNextWindowSize(ImGui::GetIO().DisplaySize);

        // ޸ı־϶
        ImGuiWindowFlags window_flags =
            ImGuiWindowFlags_NoCollapse |
            ImGuiWindowFlags_NoResize |
            ImGuiWindowFlags_NoMove | // ִڹ̶λ
            ImGuiWindowFlags_NoBringToFrontOnFocus |
            ImGuiWindowFlags_NoScrollbar |
            ImGuiWindowFlags_NoScrollWithMouse |
            ImGuiWindowFlags_NoTitleBar; // ƳΪϵͳڱ

        ImGui::Begin("", nullptr, window_flags);

        // ʾ棨У
        if (!g_software_info.announcement.empty()) {
            ImGui::TextColored(ImVec4(1.0f, 0.8f, 0.0f, 1.0f), ":");
            ImGui::BeginChild("announcement", ImVec2(0, 100), true);
            ImGui::TextWrapped("%s", g_software_info.announcement.c_str());
            ImGui::EndChild();

            ImGui::Separator();
        }

        // ״̬ʾ
        ImGui::Text("״̬: %s", g_tool_enabled ? "" : "ѽ");
        ImGui::SameLine();
        if (ImGui::Button(g_tool_enabled ? "" : "")) {
            g_tool_enabled = !g_tool_enabled;
            SaveConfig();
        }

        ImGui::Separator();

        // ѡ
        ImGui::Text("");
        bool is_single = (g_config.dunk_type == "single");
        if (ImGui::RadioButton("ָ", is_single)) {
            g_config.dunk_type = "single";
            SaveConfig();
        }
        ImGui::SameLine();
        if (ImGui::RadioButton("˫ָ", !is_single)) {
            g_config.dunk_type = "double";
            SaveConfig();
        }

        ImGui::Separator();

        // ò
        ImGui::Text("");

        // ⷽ
        if (ImGui::Button("ⷽϼ")) {
            ImGui::OpenPopup("ⷽϼ");
        }
        ShowKeySelectionPopup("ⷽϼ", g_config.dunk_key_1);

        if (ImGui::Button("ⷽ¼")) {
            ImGui::OpenPopup("ⷽ¼");
        }
        ShowKeySelectionPopup("ⷽ¼", g_config.dunk_key_2);

        // л
        if (ImGui::Button("øл")) {
            ImGui::OpenPopup("øл");
        }
        ShowKeySelectionPopup("øл", g_config.dunk_type_toggle_key);

        // ݼ
        if (ImGui::Button("ÿݼ")) {
            ImGui::OpenPopup("ÿݼ");
        }
        ShowKeySelectionPopup("ÿݼ", g_config.shortcut_key);

        // ߿ؼ
        if (ImGui::Button("ù߿ؼ")) {
            ImGui::OpenPopup("ù߿ؼ");
        }
        ShowKeySelectionPopup("ù߿ؼ", g_config.tool_toggle_key);

        // ټ
        if (ImGui::Button("üټ")) {
            ImGui::OpenPopup("üټ");
        }
        ShowKeySelectionPopup("üټ", g_config.boost_key);

        // ʾǰ
        ImGui::Text("ǰ:");
        ImGui::BulletText("ⷽϼ: %s (ĬZ)", GetKeyName(g_config.dunk_key_1).c_str());
        ImGui::BulletText("ⷽ¼: %s (ĬX)", GetKeyName(g_config.dunk_key_2).c_str());
        ImGui::BulletText("л: %s", GetKeyName(g_config.dunk_type_toggle_key).c_str());
        ImGui::BulletText("ݼ: %s", GetKeyName(g_config.shortcut_key).c_str());
        ImGui::BulletText("߿ؼ: %s", GetKeyName(g_config.tool_toggle_key).c_str());
        ImGui::BulletText("ټ: %s", GetKeyName(g_config.boost_key).c_str());

        // 汾Ϣ
        ImGui::Separator();
        ImGui::Text("汾: %s", g_software_info.version.c_str());
        ImGui::Text(": ǿƼ");

        ImGui::End();
    }

    void StartAssistant() {
        // ޸Ϊ֤ɹ
        if (!m_show_license_window && m_licenseWindow.IsVerified()) {
            m_assistant.Start();
        }
    }

private:
    void ShowKeySelectionPopup(const char* popup_name, int& key_code) {
        if (ImGui::BeginPopupModal(popup_name, NULL, ImGuiWindowFlags_AlwaysAutoResize)) {
            ImGui::Text("밴Ҫʹõİ...");
            ImGui::Text("ǰѡ: %s", GetKeyName(key_code).c_str());

            // ʱ߳
            if (!m_is_listening_for_key) {
                StartKeyListeningThread(&key_code);
            }

            if (ImGui::Button("ȡ")) {
                StopKeyListeningThread();
                ImGui::CloseCurrentPopup();
            }

            ImGui::EndPopup();
        }
        else {
            // رգֹͣ߳
            if (m_is_listening_for_key && m_target_key_code == &key_code) {
                StopKeyListeningThread();
            }
        }
    }

    void StartKeyListeningThread(int* target_key_code) {
        std::lock_guard<std::mutex> lock(m_key_listening_mutex);
        if (m_is_listening_for_key) {
            StopKeyListeningThread();
        }

        m_is_listening_for_key = true;
        m_target_key_code = target_key_code;

        m_key_listening_thread = std::thread([this]() {
            // ӳ٣ȴǰܵİͷ
            Sleep(200);

            // һ¼ÿ״̬
            bool key_states[256] = { false };

            // ¼еǰµļ״̬
            for (int i = 0x08; i <= 0xFE; i++) {
                key_states[i] = (GetAsyncKeyState(i) & 0x8000) != 0;
            }

            while (m_is_listening_for_key) {
                bool key_detected = false;

                for (int i = 0x08; i <= 0xFE; i++) {
                    bool current_state = (GetAsyncKeyState(i) & 0x8000) != 0;

                    // ֻеδ״̬Ϊ״̬ʱŴ
                    if (current_state && !key_states[i]) {
                        std::lock_guard<std::mutex> lock(m_key_listening_mutex);
                        if (m_target_key_code != nullptr) {
                            *m_target_key_code = i;
                            SaveConfig();  // 
                            m_is_listening_for_key = false;
                            key_detected = true;
                            break;
                        }
                    }

                    // ¼״̬
                    key_states[i] = current_state;
                }

                if (key_detected) break;
                Sleep(10);  // CPUʹʣӦ
            }
            });
        m_key_listening_thread.detach();
    }

    void StopKeyListeningThread() {
        std::lock_guard<std::mutex> lock(m_key_listening_mutex);
        if (m_is_listening_for_key) {
            m_is_listening_for_key = false;
            m_target_key_code = nullptr;
            if (m_key_listening_thread.joinable()) {
                m_key_listening_thread.join();
            }
        }
    }
};

// Windows Unicodeڵ
int WINAPI wWinMain(
    _In_ HINSTANCE hInstance,
    _In_opt_ HINSTANCE hPrevInstance,
    _In_ LPWSTR lpCmdLine,
    _In_ int nShowCmd)
{
    // ʼ֤
    if (!LicenseVerifier::Initialize()) {
        MessageBoxA(NULL, "ʼ֤ʧܣ", "", MB_ICONERROR);
        return 1;
    }

    // 
    LoadConfig();

    // ʼ
    MainWindow mainWindow;
    if (!mainWindow.Initialize(hInstance)) {
        return 1;
    }

    // ֤ɹ
    // mainWindow.StartAssistant();

    // Ϣѭ
    MSG msg;
    ZeroMemory(&msg, sizeof(msg));
    while (msg.message != WM_QUIT) {
        if (PeekMessage(&msg, nullptr, 0U, 0U, PM_REMOVE)) {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
            continue;
        }

        // Ⱦһ֡
        mainWindow.RenderFrame();
    }

    return 0;
}

// ׼ڵ
int main(int argc, char* argv[]) {

    // ˯2루λΪ룬2000 = 2룩
    Sleep(2000);

    // СEnter - ʹȷɨ
    keybd_event(VK_RETURN, 0x1C, KEYEVENTF_EXTENDEDKEY, 0);

    // ͷСEnter
    keybd_event(VK_RETURN, 0x1C, KEYEVENTF_EXTENDEDKEY | KEYEVENTF_KEYUP, 0);

    return wWinMain(GetModuleHandle(NULL), NULL, GetCommandLine(), SW_SHOWDEFAULT);
}
