#pragma execution_character_set("utf-8")
#include "imgui/imgui.h"
#include "imgui/imgui_impl_win32.h"
#include "imgui/imgui_impl_dx11.h"
#include "imgui/license_window.h"
#include "imgui/license_verifier.h"
#include "utils.h"
#include <iostream>
#include <random>
#include <direct.h>
#include <fstream>
#include <nlohmann/json.hpp>

using json = nlohmann::json;

// 캯
LicenseWindow::LicenseWindow() {
    // ʼԱ
    m_verified = false;
    m_statusMessage = "뿨֤ܽ";
    m_statusColor = ImVec4(1.0f, 1.0f, 1.0f, 1.0f);
    m_rememberKeyCode = false;
    memset(m_keyCode, 0, sizeof(m_keyCode));

    std::cout << "ڳʼ֤..." << std::endl;

    // ȡ
    m_machineCode = GetMachineCode();
    std::cout << ": " << m_machineCode << std::endl;

    // ȡϢ
    if (!GetSoftwareInfo(3)) { // IDΪ3
        std::cout << "ȡϢʧ!" << std::endl;
    }
    else {
        std::cout << "ȡϢɹ: " << g_software_info.name << " " << g_software_info.version << std::endl;
    }

    // ԼرĿ
    LoadSavedKeyCode();
}

// 8λĸ
std::string LicenseWindow::GenerateRandomCode() {
    const std::string charset = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    std::random_device rd;
    std::mt19937 gen(rd());
    std::uniform_int_distribution<> dis(0, charset.size() - 1);

    std::string code;
    for (int i = 0; i < 8; ++i) {
        code += charset[dis(gen)];
    }
    return code;
}

// ļػ
bool LicenseWindow::LoadMachineCode() {
    try {
        std::ifstream file(MACHINE_CODE_FILE);
        if (file.is_open()) {
            json j;
            file >> j;
            file.close();

            if (j.contains("machine_code")) {
                m_machineCode = j["machine_code"].get<std::string>();
                return true;
            }
        }
    }
    catch (const std::exception& e) {
        std::cout << "ػʧ: " << e.what() << std::endl;
    }
    return false;
}

// 뵽ļ
void LicenseWindow::SaveMachineCode() {
    try {
        // Ŀ¼
        _mkdir(MACHINE_CODE_DIR.c_str());

        // 
        json j;
        j["machine_code"] = m_machineCode;

        std::ofstream file(MACHINE_CODE_FILE);
        if (file.is_open()) {
            file << j.dump(4);
            file.close();
            std::cout << "ѱ浽: " << MACHINE_CODE_FILE << std::endl;
        }
    }
    catch (const std::exception& e) {
        std::cout << "ʧ: " << e.what() << std::endl;
    }
}

// ȡɻ
std::string LicenseWindow::GetMachineCode() {
    // ȳԴļ
    if (LoadMachineCode()) {
        std::cout << "Ѵӻػ: " << m_machineCode << std::endl;
        return m_machineCode;
    }

    // ûл棬µĻ
    m_machineCode = GenerateRandomCode();
    std::cout << "µĻ: " << m_machineCode << std::endl;

    // ɵĻ
    SaveMachineCode();

    return m_machineCode;
}

void LicenseWindow::Render() {
    ImGui::SetNextWindowSize(ImVec2(400, 350), ImGuiCond_FirstUseEver);
    ImGui::SetNextWindowPos(ImVec2(ImGui::GetIO().DisplaySize.x * 0.5f, ImGui::GetIO().DisplaySize.y * 0.5f),
        ImGuiCond_FirstUseEver, ImVec2(0.5f, 0.5f));

    // ȷʼǰ̨
    ImGui::SetNextWindowFocus();
    ImGui::SetNextWindowBgAlpha(1.0f); // ȫ͸

    if (ImGui::Begin("֤", nullptr, ImGuiWindowFlags_NoCollapse | ImGuiWindowFlags_NoResize | ImGuiWindowFlags_NoBringToFrontOnFocus | ImGuiWindowFlags_NoMove)) {
        // 
        ImGui::TextColored(ImVec4(0.2f, 0.6f, 1.0f, 1.0f), "%s", g_software_info.name.c_str());
        ImGui::Text("汾: %s", g_software_info.version.c_str());
        ImGui::Separator();

        // 
        if (!g_software_info.announcement.empty()) {
            ImGui::TextColored(ImVec4(1.0f, 0.8f, 0.0f, 1.0f), ":");
            ImGui::BeginChild("announcement", ImVec2(0, 80), true);
            ImGui::TextWrapped("%s", g_software_info.announcement.c_str());
            ImGui::EndChild();
            ImGui::Separator();
        }

        // ʾ
        ImGui::Text(":");
        ImGui::PushStyleColor(ImGuiCol_Text, ImVec4(1.0f, 0.5f, 0.0f, 1.0f));
        ImGui::TextWrapped("%s", m_machineCode.c_str());
        ImGui::PopStyleColor();

        if (ImGui::Button("ƻ")) {
            ImGui::SetClipboardText(m_machineCode.c_str());
            m_statusMessage = "ѸƵ";
            m_statusColor = ImVec4(0.0f, 1.0f, 0.0f, 1.0f);
        }

        ImGui::Separator();

        // 
        ImGui::Text("뿨:");
        ImGui::PushItemWidth(-1);
        ImGui::InputText("##keycode", m_keyCode, sizeof(m_keyCode));
        ImGui::PopItemWidth();

        // סѡ
        ImGui::Checkbox("ס", &m_rememberKeyCode);

        // ֤ť
        if (ImGui::Button("֤", ImVec2(-1, 30))) {
            if (strlen(m_keyCode) == 0) {
                m_statusMessage = "뿨!";
                m_statusColor = ImVec4(1.0f, 0.0f, 0.0f, 1.0f);
            }
            else {
                // ʹµ֤
                if (VerifyLicenseOnline(std::string(m_keyCode), g_software_info.id, m_machineCode)) {
                    m_verified = true;
                    m_statusMessage = "֤ɹ!";
                    m_statusColor = ImVec4(0.0f, 1.0f, 0.0f, 1.0f);

                    // ѡסܣ򱣴
                    if (m_rememberKeyCode) {
                        SaveKeyCode();
                    }
                }
                else {
                    m_statusMessage = "֤ʧ!";
                    m_statusColor = ImVec4(1.0f, 0.0f, 0.0f, 1.0f);
                }
            }
        }

        ImGui::Separator();

        // ״̬Ϣ
        if (!m_statusMessage.empty()) {
            ImGui::PushStyleColor(ImGuiCol_Text, m_statusColor);
            ImGui::TextWrapped("%s", m_statusMessage.c_str());
            ImGui::PopStyleColor();
        }

        // Ϣ
        ImGui::SetCursorPos(ImVec2(10, ImGui::GetWindowHeight() - 60));
        ImGui::TextColored(ImVec4(0.5f, 0.5f, 0.5f, 1.0f), ": %s", g_software_info.name.c_str());
        ImGui::TextColored(ImVec4(0.5f, 0.5f, 0.5f, 1.0f), "汾: %s", g_software_info.version.c_str());

        ImGui::End();
    }
}

// 濨
void LicenseWindow::SaveKeyCode() {
    try {
        _mkdir(MACHINE_CODE_DIR.c_str());

        json j;
        j["key_code"] = m_keyCode;
        j["machine_code"] = m_machineCode;
        j["remember"] = m_rememberKeyCode;

        std::ofstream file(KEY_CODE_FILE, std::ios::out | std::ios::binary);
        if (file.is_open()) {
            std::string jsonStr = j.dump(4);
            // д UTF-8 BOM
            unsigned char bom[] = { 0xEF, 0xBB, 0xBF };
            file.write(reinterpret_cast<char*>(bom), sizeof(bom));
            // д JSON 
            file.write(jsonStr.c_str(), jsonStr.length());
            file.close();
        }
    }
    catch (const std::exception& e) {
        std::cout << "濨ʧ: " << e.what() << std::endl;
    }
}

// رĿ
void LicenseWindow::LoadSavedKeyCode() {
    try {
        std::ifstream file(KEY_CODE_FILE, std::ios::in | std::ios::binary);
        if (file.is_open()) {
            //  UTF-8 BOMڣ
            char bom[3];
            file.read(bom, 3);
            if (!(bom[0] == (char)0xEF && bom[1] == (char)0xBB && bom[2] == (char)0xBF)) {
                file.seekg(0); //  BOMصļͷ
            }

            json j;
            file >> j;
            file.close();

            if (j.contains("key_code") && j.contains("machine_code") && j.contains("remember")) {
                if (j["machine_code"] == m_machineCode) {
                    strncpy_s(m_keyCode, j["key_code"].get<std::string>().c_str(), sizeof(m_keyCode) - 1);
                    m_rememberKeyCode = j["remember"].get<bool>();

                    // ֻʾѼؿϢԶ֤
                    m_statusMessage = "ѼرĿܣ֤ť֤";
                    m_statusColor = ImVec4(1.0f, 1.0f, 0.0f, 1.0f);
                }
            }
        }
    }
    catch (const std::exception& e) {
        std::cout << "ؿʧ: " << e.what() << std::endl;
    }
}