#pragma execution_character_set("utf-8")

#include "imgui/license_verifier.h"
#include <windows.h>
#include <iostream>
#include <sstream>
#include <curl/curl.h>
#include <fstream>
#include <nlohmann/json.hpp>

using json = nlohmann::json;

// صΪȫֺ
static size_t CurlWriteCallback(void* contents, size_t size, size_t nmemb, void* userp) {
    std::string* str = static_cast<std::string*>(userp);
    size_t totalSize = size * nmemb;
    str->append(static_cast<const char*>(contents), totalSize);
    return totalSize;
}

// ļ·
const std::string MACHINE_CODE_FILE = "C:\\2kai\\machine.json";  // ļ

bool LicenseVerifier::Initialize() {
    // ÿ̨ҳΪ UTF-8
    SetConsoleOutputCP(65001);
    // ÿ̨Ϊ֧ĵ
    CONSOLE_FONT_INFOEX cfi;
    cfi.cbSize = sizeof(cfi);
    cfi.nFont = 0;
    cfi.dwFontSize.X = 0;
    cfi.dwFontSize.Y = 16;
    cfi.FontFamily = FF_DONTCARE;
    cfi.FontWeight = FW_NORMAL;
    wcscpy_s(cfi.FaceName, L"");
    SetCurrentConsoleFontEx(GetStdHandle(STD_OUTPUT_HANDLE), FALSE, &cfi);

    // ʼCURL
    curl_global_init(CURL_GLOBAL_DEFAULT);
    return true;
}

std::string LicenseVerifier::GetMachineCode() {
    // Դļȡ
    try {
        std::ifstream file(MACHINE_CODE_FILE);
        if (file.is_open()) {
            json j;
            file >> j;
            file.close();

            if (j.contains("machine_code")) {
                std::string machineCode = j["machine_code"].get<std::string>();
                std::cout << "֤ӻػ: " << machineCode << std::endl;
                return machineCode;
            }
        }
    }
    catch (const std::exception& e) {
        std::cout << "֤ػʧ: " << e.what() << std::endl;
    }

    // ޷ȡļؼݾ߼
    char computerName[MAX_COMPUTERNAME_LENGTH + 1];
    DWORD size = sizeof(computerName);
    if (GetComputerNameA(computerName, &size)) {
        std::cout << ": ʹüΪ: " << computerName << std::endl;
        return std::string(computerName);
    }
    return "UNKNOWN";
}

bool LicenseVerifier::VerifyLicense(const std::string& keyCode, int softwareId) {
    CURL* curl = curl_easy_init();
    bool result = false;

    if (curl) {
        std::string machineCode = GetMachineCode();

        // ӡ֤ϢοPythonʾʽ
        std::cout << "\n֤֤..." << std::endl;
        std::cout << ": " << machineCode << std::endl;
        std::cout << "ID: " << softwareId << std::endl;
        std::cout << "֤Կ: " << keyCode << std::endl;

        // JSON壨Python뱣һµֶ
        std::stringstream jsonData;
        jsonData << "{"
            << "\"key_code\":\"" << keyCode << "\","    // ʹ key_code
            << "\"software_id\":" << softwareId << ","  // ʹ software_id
            << "\"device_code\":\"" << machineCode << "\""  // ʹ device_code
            << "}";

        std::string postData = jsonData.str();
        std::string readBuffer;
        std::string url = "http://117.72.182.10:8080/api/license/verify";  // PythonʹͬURL

        // CURLѡ
        curl_easy_setopt(curl, CURLOPT_URL, url.c_str());
        curl_easy_setopt(curl, CURLOPT_POST, 1L);
        curl_easy_setopt(curl, CURLOPT_POSTFIELDS, postData.c_str());
        curl_easy_setopt(curl, CURLOPT_POSTFIELDSIZE, postData.length());
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, CurlWriteCallback);
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, &readBuffer);
        curl_easy_setopt(curl, CURLOPT_TIMEOUT, 5L);

        // ͷPythonһ£
        struct curl_slist* headers = NULL;
        headers = curl_slist_append(headers, "Content-Type: application/json");
        headers = curl_slist_append(headers, "Accept: application/json");
        curl_easy_setopt(curl, CURLOPT_HTTPHEADER, headers);

        // ӡϢ
        std::cout << ": " << postData << std::endl;
        std::cout << "ӷ..." << std::endl;

        CURLcode res = curl_easy_perform(curl);

        if (res == CURLE_OK) {
            long response_code;
            curl_easy_getinfo(curl, CURLINFO_RESPONSE_CODE, &response_code);

            // PythonĴ߼жӦ
            if (response_code == 200) {
                // ԽJSONӦ
                if (!readBuffer.empty()) {
                    std::cout << "֤ɹ֤Ч" << std::endl;
                    std::cout << "Ӧ: " << readBuffer << std::endl;
                    result = true;
                }
            }
            else if (response_code == 404) {
                std::cout << ": ܲڻڴ!" << std::endl;
            }
            else if (response_code == 403) {
                std::cout << ": " << readBuffer << std::endl;
            }
            else {
                std::cout << "֤ʧܣ֤Ч" << std::endl;
                std::cout << ": " << response_code << std::endl;
                std::cout << "Ӧ: " << readBuffer << std::endl;
            }
        }
        else {
            std::cout << "ӷʧܣ" << std::endl;
            std::cout << "Ϣ: " << curl_easy_strerror(res) << std::endl;
        }

        // 
        curl_slist_free_all(headers);
        curl_easy_cleanup(curl);
    }
    else {
        std::cout << "ʼCURLʧܣ" << std::endl;
    }

    return result;
}